using System;
using System.Data;

public class CMain
{
  static void WypiszInfoODataSet( DataSet d )
  {
    Console.WriteLine( "DataSet {0} zawiera {1} tabele", d.DataSetName, d.Tables.Count );
 
    foreach ( DataTable t in d.Tables )
    {
      Console.WriteLine( "Tabela {0} zawiera {1} wiersze", 
                         t.TableName, t.Rows.Count );
      foreach ( DataRow r in t.Rows )
      {
        Console.Write( "-> " );
        foreach ( DataColumn c in t.Columns )
          Console.Write( "{0}={1}, ", c.ColumnName, r[c.ColumnName] );
        Console.WriteLine();        
      }
    }
  }

  public static void Main()
  {
    // zbir danych
    DataSet dataSet = new DataSet( "DataSetOsoby" );

    // tabela
    DataTable dataTable = new DataTable( "Osoby" );
    dataSet.Tables.Add( dataTable );

    // kolumny tabeli
    DataColumn dataColumn1 = new DataColumn( "Imi", typeof(string) );
    DataColumn dataColumn2 = new DataColumn( "Nazwisko", typeof(string) );
    DataColumn dataColumn3 = new DataColumn( "Data urodzenia", typeof(DateTime) );

    dataTable.Columns.AddRange( new DataColumn[] { dataColumn1, dataColumn2, dataColumn3 } );

    // wiersze
    DataRow row;

    row = dataTable.NewRow();
    row["Imi"]           = "Adam";
    row["Nazwisko"]       = "Kowalski";
    row["Data urodzenia"] = DateTime.Parse( "1992-05-01" );
    dataTable.Rows.Add( row ); 

    row = dataTable.NewRow();
    row["Imi"]           = "Tomasz";
    row["Nazwisko"]       = "Malinowski";
    row["Data urodzenia"] = DateTime.Parse( "1997-07-12" );
    dataTable.Rows.Add( row ); 
    
    WypiszInfoODataSet( dataSet );
  }
}
